from typing import Any, Dict, Optional, Union

import httpx

from ...client import Client
from ...models.form_definitions_paginated_list import FormDefinitionsPaginatedList
from ...models.get_form_definitions_sort import GetFormDefinitionsSort
from ...types import Response, UNSET, Unset


def _get_kwargs(
    *,
    client: Client,
    next_token: Union[Unset, str] = UNSET,
    page_size: Union[Unset, int] = 50,
    modified_at: Union[Unset, str] = UNSET,
    sort: Union[Unset, GetFormDefinitionsSort] = GetFormDefinitionsSort.MODIFIEDATDESC,
) -> Dict[str, Any]:
    url = "{}/form-definitions".format(client.base_url)

    headers: Dict[str, Any] = client.httpx_client.headers
    headers.update(client.get_headers())

    cookies: Dict[str, Any] = client.httpx_client.cookies
    cookies.update(client.get_cookies())

    json_sort: Union[Unset, int] = UNSET
    if not isinstance(sort, Unset):
        json_sort = sort.value

    params: Dict[str, Any] = {}
    if not isinstance(next_token, Unset) and next_token is not None:
        params["nextToken"] = next_token
    if not isinstance(page_size, Unset) and page_size is not None:
        params["pageSize"] = page_size
    if not isinstance(modified_at, Unset) and modified_at is not None:
        params["modifiedAt"] = modified_at
    if not isinstance(json_sort, Unset) and json_sort is not None:
        params["sort"] = json_sort

    return {
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "params": params,
    }


def _parse_response(*, response: httpx.Response) -> Optional[FormDefinitionsPaginatedList]:
    if response.status_code == 200:
        response_200 = FormDefinitionsPaginatedList.from_dict(response.json())

        return response_200
    return None


def _build_response(*, response: httpx.Response) -> Response[FormDefinitionsPaginatedList]:
    return Response(
        status_code=response.status_code,
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(response=response),
    )


def sync_detailed(
    *,
    client: Client,
    next_token: Union[Unset, str] = UNSET,
    page_size: Union[Unset, int] = 50,
    modified_at: Union[Unset, str] = UNSET,
    sort: Union[Unset, GetFormDefinitionsSort] = GetFormDefinitionsSort.MODIFIEDATDESC,
) -> Response[FormDefinitionsPaginatedList]:
    kwargs = _get_kwargs(
        client=client,
        next_token=next_token,
        page_size=page_size,
        modified_at=modified_at,
        sort=sort,
    )

    response = client.httpx_client.get(
        **kwargs,
    )

    return _build_response(response=response)


def sync(
    *,
    client: Client,
    next_token: Union[Unset, str] = UNSET,
    page_size: Union[Unset, int] = 50,
    modified_at: Union[Unset, str] = UNSET,
    sort: Union[Unset, GetFormDefinitionsSort] = GetFormDefinitionsSort.MODIFIEDATDESC,
) -> Optional[FormDefinitionsPaginatedList]:
    """Lists available form definitions. Only the latest version along is returned for each definition."""

    return sync_detailed(
        client=client,
        next_token=next_token,
        page_size=page_size,
        modified_at=modified_at,
        sort=sort,
    ).parsed


async def asyncio_detailed(
    *,
    client: Client,
    next_token: Union[Unset, str] = UNSET,
    page_size: Union[Unset, int] = 50,
    modified_at: Union[Unset, str] = UNSET,
    sort: Union[Unset, GetFormDefinitionsSort] = GetFormDefinitionsSort.MODIFIEDATDESC,
) -> Response[FormDefinitionsPaginatedList]:
    kwargs = _get_kwargs(
        client=client,
        next_token=next_token,
        page_size=page_size,
        modified_at=modified_at,
        sort=sort,
    )

    async with httpx.AsyncClient() as _client:
        response = await _client.get(**kwargs)

    return _build_response(response=response)


async def asyncio(
    *,
    client: Client,
    next_token: Union[Unset, str] = UNSET,
    page_size: Union[Unset, int] = 50,
    modified_at: Union[Unset, str] = UNSET,
    sort: Union[Unset, GetFormDefinitionsSort] = GetFormDefinitionsSort.MODIFIEDATDESC,
) -> Optional[FormDefinitionsPaginatedList]:
    """Lists available form definitions. Only the latest version along is returned for each definition."""

    return (
        await asyncio_detailed(
            client=client,
            next_token=next_token,
            page_size=page_size,
            modified_at=modified_at,
            sort=sort,
        )
    ).parsed
