# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['mkkey']

package_data = \
{'': ['*']}

install_requires = \
['click-help-colors>=0.9.1,<0.10.0',
 'click>=8.0.3,<9.0.0',
 'cryptography>=36.0.0,<37.0.0',
 'pyseto>=1.5.0,<2.0.0',
 'shellingham>=1.4.0,<2.0.0']

entry_points = \
{'console_scripts': ['mkkey = mkkey.cli:cli']}

setup_kwargs = {
    'name': 'mkkey',
    'version': '0.3.0',
    'description': 'A Generic Application-Layer Key Generator supporting JWK and PASERK.',
    'long_description': '# mkkey - An Application-Layer Key Generator supporting JWK and PASERK.\n\n[![PyPI version](https://badge.fury.io/py/mkkey.svg)](https://badge.fury.io/py/mkkey)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mkkey)\n![Github CI](https://github.com/dajiaji/mkkey/actions/workflows/python-package.yml/badge.svg)\n[![codecov](https://codecov.io/gh/dajiaji/mkkey/branch/main/graph/badge.svg?token=QN8GXEYEP3)](https://codecov.io/gh/dajiaji/mkkey)\n\nmkkey is a CLI tool for generating following application-layer keys:\n- [RFC7517 - JWK (JSON Web Key)](https://datatracker.ietf.org/doc/html/rfc7517)\n- [PASERK (Platform-Agnositc Serialized Keys)](https://github.com/paseto-standard/paserk)\n\nUntil now, in order to create a JWK, you had to create a PEM-formatted key pair using a command\nsuch as `openssl`, and then load it and convert it into a JWK. With `mkkey`, you can\ndirectly and easily create JWKs and PASERKs that can be used in applications as shown below,\nwithout generating intermediate keys (PEM-formatted keys):\n\n![mkkey](https://github.com/dajiaji/mkkey/wiki/images/mkkey_header.png)\n\n# Index\n\n- [Installation](#installation)\n- [Basic Usage](#basic-usage)\n  - [JWK (JSON Web Key)](#jwk-json-web-key)\n      - [Generate a simple (default) JWK](#generate-a-simple-default-jwk)\n      - [Generate a JWK with specifying curve](#generate-a-jwk-with-specifying-curve)\n      - [Generate a JWK with optional attributes](#generate-a-jwk-with-optional-attributes)\n      - [Generate a JWK with kid generation method](#generate-a-jwk-with-kid-generation-method)\n  - [PASERK (Platform-Agnostic Serialized Keys)](#paserk-platform-agnostic-serialized-keys)\n      - [Generate a PASERK](#generate-a-paserk)\n      - [Generate a PASERK along with a PASERK ID](#generate-a-paserk-along-with-a-paserk-id)\n- [kid generation methods for JWK](#kid-generation-methods-for-jwk)\n- [Contributing](#contributing)\n\n# Installation\n\nYou can install mkkey with pip:\n\n```sh\n$ pip install mkkey\n```\n\nIf the shell you are using is `bash`, `zsh` or `fish`, you can activate tab completion\nby following the steps below:\n\n1. Run `mkkey --install`.\n2. Follow the steps described in the output of `mkkey --install`.\n\n# Basic Usage\n\n## JWK (JSON Web Key)\n\nJWKs can be generated using the `mkkey jwk` command.\n\nTypical use cases are shown in this section but for details, see help:\n\n```sh\n$ mkkey jwk --help\n```\n\n### Generate a simple (default) JWK\n\nThe simplest way to use `mkkey jwt` is as follows. Simply specify a key type (in this case, `ec`).\nNow you will get the minimum JWK you need.\n\n```sh\n$ mkkey jwk ec\n{\n    "public": {\n        "jwk": {\n            "kty": "EC",\n            "crv": "P-256",\n            "x": "Ti-mNoi-uQFYBVNkH6BSmuTAd8WL8kyEVJufZYv3mG8",\n            "y": "ANwoZQFI_teNrltM0s9LPjWli0_zyYvvv8cEZWKx1CQ"\n        }\n    },\n    "secret": {\n        "jwk": {\n            "kty": "EC",\n            "crv": "P-256",\n            "x": "Ti-mNoi-uQFYBVNkH6BSmuTAd8WL8kyEVJufZYv3mG8",\n            "y": "ANwoZQFI_teNrltM0s9LPjWli0_zyYvvv8cEZWKx1CQ",\n            "d": "l9Pbq0BmCsOzdapBtSxVpRiHhDTK5-ATteA0nMKzvFU"\n        }\n    }\n}\n```\n\nIn addtion to `ec`, `rsa` and `okp` (Octet Key Pair) can be used as key types:\n\n```sh\n$ mkkey jwk rsa\n$ mkkey jwk okp\n```\n\n### Generate a JWK with specifying curve\n\nIf you want to use a curve other than `P-256`, use the `--crv` option:\n\n```sh\n$ mkkey jwk ec --crv P-384\n```\n\n### Generate a JWK with optional attributes\n\nIf you want to include `kid`, `alg`, `use` and `key_ops` in the JWK,\nuse the `--kid`, `--alg`, `--use`, and `--key-ops` respectively:\n\n```sh\n$ mkkey jwk ec --kid 01 --alg ES256 --use sig --key-ops\n{\n    "public": {\n        "jwk": {\n            "kid": "01",\n            "kty": "EC",\n            "crv": "P-256",\n            "alg": "ES256",\n            "use": "sig",\n            "key_ops": ["verify"],\n            "x": "qg-3SA7jNvG7DPF8ajuRR69d5LoBz-I8Xg4ze1kjdHs",\n            "y": "JctPLnWOeyJM3apWxyEX3bHDo97kel4gdI8x0FlTwHc"\n        }\n    },\n    "secret": {\n        "jwk": {\n            "kid": "01",\n            "kty": "EC",\n            "crv": "P-256",\n            "alg": "ES256",\n            "use": "sig",\n            "key_ops": ["sign"],\n            "x": "qg-3SA7jNvG7DPF8ajuRR69d5LoBz-I8Xg4ze1kjdHs",\n            "y": "JctPLnWOeyJM3apWxyEX3bHDo97kel4gdI8x0FlTwHc",\n            "d": "GZ9ihMNwYYbglWHV8vau-W5gaZal5ajBb_NiY7Ci7Uk"\n        }\n    }\n}\n```\n\n### Generate a JWK with kid generation method\n\n`kid` can also be generated automatically. In this case, use `--kid-type` to specify the generation method.\nFor now, only `sha256` (see [kid generation methods for JWK](#kid-generation-methods-for-jwk)) is available.\nYou can adjust the size of the auto-generated kid by using `--kid-size` as well:\n\n```sh\n$ mkkey jwk ec --kid-type sha256 --kid-size 16\n{\n    "public": {\n        "jwk": {\n            "kid": "ozh_CYlRd3A1f2RLlA3Y5w",\n            "kty": "EC",\n            "crv": "P-256",\n            "x": "hDuMnnmlnFAKMsn-qP37XsKchg6K0bXPhsFgmWOpnVw",\n            "y": "_oQgP8b8V0hC_H73gIVBaMylAoTOA4mwM57Y2hC2xIk"\n        }\n    },\n    "secret": {\n        "jwk": {\n            "kid": "ozh_CYlRd3A1f2RLlA3Y5w",\n            "kty": "EC",\n            "crv": "P-256",\n            "x": "hDuMnnmlnFAKMsn-qP37XsKchg6K0bXPhsFgmWOpnVw",\n            "y": "_oQgP8b8V0hC_H73gIVBaMylAoTOA4mwM57Y2hC2xIk",\n            "d": "1b0lNEiyV_C8U0fGXDczfwTrKnHpWwjt_OU0H-MLJvs"\n        }\n    }\n}\n```\n\n## PASERK (Platform-Agnostic Serialized Keys)\n\nPASERKs can be generated using the `mkkey paserk` command.\n\nTypical use cases are shown in this section but for details, see help:\n\n```sh\n$ mkkey paserk --help\n```\n\n### Generate a PASERK\n\nPASERKs can be generated using the `mkkey paserk` command with a target PASETO version\nand a purpose (in this case, `v4` and `public` respectively).\n\n```sh\n$ mkkey paserk v4 public\n{\n    "public": {\n        "paserk": "k4.public.2BWUTPg5pmXZ3EVrOBv9I4I_F8Afj0TJ21HkaPT926M"\n    },\n    "secret": {\n        "paserk": "k4.secret.fKIawV2PPVpEONDcEH3_p1dc4OEYlTncmMa8gvwMVy_YFZRM-DmmZdncRWs4G_0jgj8XwB-PRMnbUeRo9P3bow"\n    }\n}\n\n```\n\n### Generate a PASERK along with a PASERK ID\n\nIf you want to generate a PASERK ID (`kid`) along with a PASERK, use the `--kid` option:\n\n```sh\n$ mkkey paserk v4 public --kid\n{\n    "public": {\n        "kid": "k4.pid.B7i9vMzTQv32mDV9JKjyRy5Iu4eyuufb_RjXwQeZiGrh",\n        "paserk": "k4.public.Qo7ipKpEa2RxCqmVXSpHdRbWMGtg9QsesMUbLQfU_Pw"\n    },\n    "secret": {\n        "kid": "k4.sid.v1091k4VuZOEKfIO5hLByGwK-RP6dFhfaltURc4CFkUd",\n        "paserk": "k4.secret.0h5Q2HDR8PbFMZhN8z7iXbbCyn5-bRQdNPRYIglvnWdCjuKkqkRrZHEKqZVdKkd1FtYwa2D1Cx6wxRstB9T8_A"\n    }\n}\n```\n\n## kid generation methods for JWK\n\nFollowing kid generation methods are available that can be specified as `--kid-type` option:\n\n- `sha256`: Use a SHA256 hash value of PEM-formatted public key bytes as a kid value. The PEM format must be subject public key info which starts with `-----BEGIN PUBLIC KEY-----` and the hash value must be base64 URL encoded.\n- `none`: Do not generate kid [default].\n\n## Contributing\n\nWe welcome all kind of contributions, filing issues, suggesting new features or sending PRs.\n',
    'author': 'Ajitomi Daisuke',
    'author_email': 'dajiaji@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/dajiaji/mkkey',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
