#!/bin/bash
# ~~ Generated by projen. To modify, edit .projenrc.js and run "npx projen".
exec node <<-EOF
const os = require('os');
const { env, exit } = require('process');
const { StepFunctions } = require('aws-sdk');
const { handler } = require('/bundle/index.js');
const sfn = new StepFunctions();
const taskToken = env.SFN_TASK_TOKEN;
delete env.SFN_TASK_TOKEN;
const sendHeartbeat = () => sfn.sendTaskHeartbeat({ taskToken }).promise().then(
  () => console.log('Successfully sent task heartbeat!'),
  (reason) => {
    console.error('Failed to send task heartbeat:', reason);
    if (reason.code === 'TaskTimedOut') {
      exit(-(os.constants.errno.ETIMEDOUT || 1));
    }
  },
);
sendHeartbeat();
const heartbeat = setInterval(sendHeartbeat, 60000);
(async () => handler($@))()
  .then((value) => {
    console.log('Handler result:', JSON.stringify(value, null, 2));
    return sfn.sendTaskSuccess({ output: JSON.stringify(value), taskToken }).promise()
  })
  .catch((reason) => {
    console.error('Execution error:', reason);
    return sfn.sendTaskFailure({ cause: JSON.stringify(reason), error: reason.name || reason.constructor.name || 'Error', taskToken }).promise();
  })
  .finally(() => clearInterval(heartbeat));
EOF