export interface CodeArtifactProps {
    /**
     * The endpoint for the CodeArtifact NPM registry. It is a complete URL
     * (including protocol, and path).
     */
    readonly endpoint: string;
    /**
     * The name of the CodeArtifact domain that contains the NPM registry.
     */
    readonly domain: string;
    /**
     * The owner of the CodeArtifact domain that contains the NPM registry.
     */
    readonly domainOwner?: string;
    /**
     * The CodeArtifact API endpoints to be used (e.g: VPC Endpoints).
     */
    readonly apiEndpoint?: string;
}
/**
 * Logs into the provided CodeArtifact registry, and makes it the default NPM
 * registry for this environment.
 */
export declare function logInWithCodeArtifact({ endpoint, domain, domainOwner, apiEndpoint }: CodeArtifactProps): Promise<void>;
