# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class DockerRunData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'MongoObjectID',
        'docker_version': 'str',
        'dataset_id': 'MongoObjectID',
        'state': 'DockerRunState',
        'created_at': 'Timestamp',
        'last_modified_at': 'Timestamp',
        'message': 'str',
        'messages': 'list[DockerRunDataLog]',
        'report_available': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'docker_version': 'dockerVersion',
        'dataset_id': 'datasetId',
        'state': 'state',
        'created_at': 'createdAt',
        'last_modified_at': 'lastModifiedAt',
        'message': 'message',
        'messages': 'messages',
        'report_available': 'reportAvailable'
    }

    def __init__(self, id=None, docker_version=None, dataset_id=None, state=None, created_at=None, last_modified_at=None, message=None, messages=None, report_available=None, _configuration=None):  # noqa: E501
        """DockerRunData - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._docker_version = None
        self._dataset_id = None
        self._state = None
        self._created_at = None
        self._last_modified_at = None
        self._message = None
        self._messages = None
        self._report_available = None
        self.discriminator = None

        self.id = id
        self.docker_version = docker_version
        if dataset_id is not None:
            self.dataset_id = dataset_id
        self.state = state
        self.created_at = created_at
        self.last_modified_at = last_modified_at
        if message is not None:
            self.message = message
        if messages is not None:
            self.messages = messages
        if report_available is not None:
            self.report_available = report_available

    @property
    def id(self):
        """Gets the id of this DockerRunData.  # noqa: E501


        :return: The id of this DockerRunData.  # noqa: E501
        :rtype: MongoObjectID
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DockerRunData.


        :param id: The id of this DockerRunData.  # noqa: E501
        :type: MongoObjectID
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def docker_version(self):
        """Gets the docker_version of this DockerRunData.  # noqa: E501


        :return: The docker_version of this DockerRunData.  # noqa: E501
        :rtype: str
        """
        return self._docker_version

    @docker_version.setter
    def docker_version(self, docker_version):
        """Sets the docker_version of this DockerRunData.


        :param docker_version: The docker_version of this DockerRunData.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and docker_version is None:
            raise ValueError("Invalid value for `docker_version`, must not be `None`")  # noqa: E501

        self._docker_version = docker_version

    @property
    def dataset_id(self):
        """Gets the dataset_id of this DockerRunData.  # noqa: E501


        :return: The dataset_id of this DockerRunData.  # noqa: E501
        :rtype: MongoObjectID
        """
        return self._dataset_id

    @dataset_id.setter
    def dataset_id(self, dataset_id):
        """Sets the dataset_id of this DockerRunData.


        :param dataset_id: The dataset_id of this DockerRunData.  # noqa: E501
        :type: MongoObjectID
        """

        self._dataset_id = dataset_id

    @property
    def state(self):
        """Gets the state of this DockerRunData.  # noqa: E501


        :return: The state of this DockerRunData.  # noqa: E501
        :rtype: DockerRunState
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this DockerRunData.


        :param state: The state of this DockerRunData.  # noqa: E501
        :type: DockerRunState
        """
        if self._configuration.client_side_validation and state is None:
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501

        self._state = state

    @property
    def created_at(self):
        """Gets the created_at of this DockerRunData.  # noqa: E501


        :return: The created_at of this DockerRunData.  # noqa: E501
        :rtype: Timestamp
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this DockerRunData.


        :param created_at: The created_at of this DockerRunData.  # noqa: E501
        :type: Timestamp
        """
        if self._configuration.client_side_validation and created_at is None:
            raise ValueError("Invalid value for `created_at`, must not be `None`")  # noqa: E501

        self._created_at = created_at

    @property
    def last_modified_at(self):
        """Gets the last_modified_at of this DockerRunData.  # noqa: E501


        :return: The last_modified_at of this DockerRunData.  # noqa: E501
        :rtype: Timestamp
        """
        return self._last_modified_at

    @last_modified_at.setter
    def last_modified_at(self, last_modified_at):
        """Sets the last_modified_at of this DockerRunData.


        :param last_modified_at: The last_modified_at of this DockerRunData.  # noqa: E501
        :type: Timestamp
        """
        if self._configuration.client_side_validation and last_modified_at is None:
            raise ValueError("Invalid value for `last_modified_at`, must not be `None`")  # noqa: E501

        self._last_modified_at = last_modified_at

    @property
    def message(self):
        """Gets the message of this DockerRunData.  # noqa: E501


        :return: The message of this DockerRunData.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this DockerRunData.


        :param message: The message of this DockerRunData.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def messages(self):
        """Gets the messages of this DockerRunData.  # noqa: E501


        :return: The messages of this DockerRunData.  # noqa: E501
        :rtype: list[DockerRunDataLog]
        """
        return self._messages

    @messages.setter
    def messages(self, messages):
        """Sets the messages of this DockerRunData.


        :param messages: The messages of this DockerRunData.  # noqa: E501
        :type: list[DockerRunDataLog]
        """

        self._messages = messages

    @property
    def report_available(self):
        """Gets the report_available of this DockerRunData.  # noqa: E501


        :return: The report_available of this DockerRunData.  # noqa: E501
        :rtype: bool
        """
        return self._report_available

    @report_available.setter
    def report_available(self, report_available):
        """Sets the report_available of this DockerRunData.


        :param report_available: The report_available of this DockerRunData.  # noqa: E501
        :type: bool
        """

        self._report_available = report_available

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DockerRunData, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DockerRunData):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DockerRunData):
            return True

        return self.to_dict() != other.to_dict()
