# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lightly.openapi_generated.swagger_client.api_client import ApiClient


class TagsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_initial_tag_by_dataset_id(self, body, dataset_id, **kwargs):  # noqa: E501
        """create_initial_tag_by_dataset_id  # noqa: E501

        create the intitial tag for a dataset which then locks the dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_initial_tag_by_dataset_id(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InitialTagCreateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_initial_tag_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_initial_tag_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
            return data

    def create_initial_tag_by_dataset_id_with_http_info(self, body, dataset_id, **kwargs):  # noqa: E501
        """create_initial_tag_by_dataset_id  # noqa: E501

        create the intitial tag for a dataset which then locks the dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_initial_tag_by_dataset_id_with_http_info(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param InitialTagCreateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_initial_tag_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_initial_tag_by_dataset_id`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `create_initial_tag_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/initial', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tag_by_dataset_id(self, body, dataset_id, **kwargs):  # noqa: E501
        """create_tag_by_dataset_id  # noqa: E501

        create new tag for dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tag_by_dataset_id(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagCreateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tag_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tag_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
            return data

    def create_tag_by_dataset_id_with_http_info(self, body, dataset_id, **kwargs):  # noqa: E501
        """create_tag_by_dataset_id  # noqa: E501

        create new tag for dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tag_by_dataset_id_with_http_info(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagCreateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tag_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_tag_by_dataset_id`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `create_tag_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tag_by_tag_id(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """delete_tag_by_tag_id  # noqa: E501

        delete a specific tag if its a leaf-tag (e.g is not a dependency of another tag)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_by_tag_id(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tag_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tag_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def delete_tag_by_tag_id_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """delete_tag_by_tag_id  # noqa: E501

        delete a specific tag if its a leaf-tag (e.g is not a dependency of another tag)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_by_tag_id_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tag_by_tag_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `delete_tag_by_tag_id`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `delete_tag_by_tag_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_zip_of_samples_by_tag_id(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """download_zip_of_samples_by_tag_id  # noqa: E501

        Download a zip file of the samples of a tag. Limited to 1000 images  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_zip_of_samples_by_tag_id(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.download_zip_of_samples_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_zip_of_samples_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def download_zip_of_samples_by_tag_id_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """download_zip_of_samples_by_tag_id  # noqa: E501

        Download a zip file of the samples of a tag. Limited to 1000 images  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.download_zip_of_samples_by_tag_id_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_zip_of_samples_by_tag_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `download_zip_of_samples_by_tag_id`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `download_zip_of_samples_by_tag_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}/export/zip', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_tag_to_basic_filenames(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_basic_filenames  # noqa: E501

        Export the samples filenames of a specific tag   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_basic_filenames(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_tag_to_basic_filenames_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_tag_to_basic_filenames_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def export_tag_to_basic_filenames_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_basic_filenames  # noqa: E501

        Export the samples filenames of a specific tag   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_basic_filenames_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id', 'expires_in', 'access_control', 'file_name_format', 'include_meta_data', 'format', 'preview_example']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_tag_to_basic_filenames" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `export_tag_to_basic_filenames`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `export_tag_to_basic_filenames`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []
        if 'expires_in' in params:
            query_params.append(('expiresIn', params['expires_in']))  # noqa: E501
        if 'access_control' in params:
            query_params.append(('accessControl', params['access_control']))  # noqa: E501
        if 'file_name_format' in params:
            query_params.append(('fileNameFormat', params['file_name_format']))  # noqa: E501
        if 'include_meta_data' in params:
            query_params.append(('includeMetaData', params['include_meta_data']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'preview_example' in params:
            query_params.append(('previewExample', params['preview_example']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}/export/basic/filenames', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_tag_to_label_box_data_rows(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_label_box_data_rows  # noqa: E501

        Export samples of a tag as a json for importing into LabelBox as outlined here; https://docs.labelbox.com/docs/images-json ```openapi\\+warning The image URLs are special in that the resource can be accessed by anyone in possession of said URL for the time specified by the expiresIn query param ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_label_box_data_rows(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: LabelBoxDataRows
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_tag_to_label_box_data_rows_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_tag_to_label_box_data_rows_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def export_tag_to_label_box_data_rows_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_label_box_data_rows  # noqa: E501

        Export samples of a tag as a json for importing into LabelBox as outlined here; https://docs.labelbox.com/docs/images-json ```openapi\\+warning The image URLs are special in that the resource can be accessed by anyone in possession of said URL for the time specified by the expiresIn query param ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_label_box_data_rows_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: LabelBoxDataRows
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id', 'expires_in', 'access_control', 'file_name_format', 'include_meta_data', 'format', 'preview_example']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_tag_to_label_box_data_rows" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `export_tag_to_label_box_data_rows`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `export_tag_to_label_box_data_rows`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []
        if 'expires_in' in params:
            query_params.append(('expiresIn', params['expires_in']))  # noqa: E501
        if 'access_control' in params:
            query_params.append(('accessControl', params['access_control']))  # noqa: E501
        if 'file_name_format' in params:
            query_params.append(('fileNameFormat', params['file_name_format']))  # noqa: E501
        if 'include_meta_data' in params:
            query_params.append(('includeMetaData', params['include_meta_data']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'preview_example' in params:
            query_params.append(('previewExample', params['preview_example']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}/export/LabelBox/datarows', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelBoxDataRows',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_tag_to_label_studio_tasks(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_label_studio_tasks  # noqa: E501

        Export samples of a tag as a json for importing into LabelStudio as outlined here; https://labelstud.io/guide/tasks.html#Basic-Label-Studio-JSON-format ```openapi\\+warning The image URLs are special in that the resource can be accessed by anyone in possession of said URL for the time specified by the expiresIn query param ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_label_studio_tasks(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: LabelStudioTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_tag_to_label_studio_tasks_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_tag_to_label_studio_tasks_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def export_tag_to_label_studio_tasks_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_label_studio_tasks  # noqa: E501

        Export samples of a tag as a json for importing into LabelStudio as outlined here; https://labelstud.io/guide/tasks.html#Basic-Label-Studio-JSON-format ```openapi\\+warning The image URLs are special in that the resource can be accessed by anyone in possession of said URL for the time specified by the expiresIn query param ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_label_studio_tasks_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: LabelStudioTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id', 'expires_in', 'access_control', 'file_name_format', 'include_meta_data', 'format', 'preview_example']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_tag_to_label_studio_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `export_tag_to_label_studio_tasks`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `export_tag_to_label_studio_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []
        if 'expires_in' in params:
            query_params.append(('expiresIn', params['expires_in']))  # noqa: E501
        if 'access_control' in params:
            query_params.append(('accessControl', params['access_control']))  # noqa: E501
        if 'file_name_format' in params:
            query_params.append(('fileNameFormat', params['file_name_format']))  # noqa: E501
        if 'include_meta_data' in params:
            query_params.append(('includeMetaData', params['include_meta_data']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'preview_example' in params:
            query_params.append(('previewExample', params['preview_example']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}/export/LabelStudio/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LabelStudioTasks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def export_tag_to_sama_tasks(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_sama_tasks  # noqa: E501

        Export samples of a tag as a json for importing into Sama as tasks with the upload form or via the API as outlined here; - https://docs.sama.com/reference/taskcreate - https://docs.sama.com/reference/createbatch  ```openapi\\+warning The image URLs are special in that the resource can be accessed by anyone in possession of said URL for the time specified by the expiresIn query param ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_sama_tasks(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: SamaTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_tag_to_sama_tasks_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.export_tag_to_sama_tasks_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def export_tag_to_sama_tasks_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """export_tag_to_sama_tasks  # noqa: E501

        Export samples of a tag as a json for importing into Sama as tasks with the upload form or via the API as outlined here; - https://docs.sama.com/reference/taskcreate - https://docs.sama.com/reference/createbatch  ```openapi\\+warning The image URLs are special in that the resource can be accessed by anyone in possession of said URL for the time specified by the expiresIn query param ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_tag_to_sama_tasks_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :param int expires_in: if defined, the URLs provided will only be valid for amount of seconds from time of issuence
        :param str access_control: which access control name to be used
        :param FileNameFormat file_name_format:
        :param bool include_meta_data: if true, will also include metadata
        :param FileOutputFormat format:
        :param bool preview_example: if true, will generate a preview example of how the structure will look
        :return: SamaTasks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id', 'expires_in', 'access_control', 'file_name_format', 'include_meta_data', 'format', 'preview_example']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_tag_to_sama_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `export_tag_to_sama_tasks`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `export_tag_to_sama_tasks`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []
        if 'expires_in' in params:
            query_params.append(('expiresIn', params['expires_in']))  # noqa: E501
        if 'access_control' in params:
            query_params.append(('accessControl', params['access_control']))  # noqa: E501
        if 'file_name_format' in params:
            query_params.append(('fileNameFormat', params['file_name_format']))  # noqa: E501
        if 'include_meta_data' in params:
            query_params.append(('includeMetaData', params['include_meta_data']))  # noqa: E501
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501
        if 'preview_example' in params:
            query_params.append(('previewExample', params['preview_example']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}/export/Sama/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SamaTasks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_filenames_by_tag_id(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """get_filenames_by_tag_id  # noqa: E501

        Get list of filenames by tag. Deprecated, please use  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_filenames_by_tag_id(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: TagFilenamesData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_filenames_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_filenames_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def get_filenames_by_tag_id_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """get_filenames_by_tag_id  # noqa: E501

        Get list of filenames by tag. Deprecated, please use  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_filenames_by_tag_id_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: TagFilenamesData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_filenames_by_tag_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_filenames_by_tag_id`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `get_filenames_by_tag_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}/filenames', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagFilenamesData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tag_by_tag_id(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """get_tag_by_tag_id  # noqa: E501

        Get information about a specific tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tag_by_tag_id(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: TagData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tag_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tag_by_tag_id_with_http_info(dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def get_tag_by_tag_id_with_http_info(self, dataset_id, tag_id, **kwargs):  # noqa: E501
        """get_tag_by_tag_id  # noqa: E501

        Get information about a specific tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tag_by_tag_id_with_http_info(dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: TagData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'tag_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tag_by_tag_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_tag_by_tag_id`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `get_tag_by_tag_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tags_by_dataset_id(self, dataset_id, **kwargs):  # noqa: E501
        """get_tags_by_dataset_id  # noqa: E501

        Get all tags of a dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_by_dataset_id(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: list[TagData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tags_by_dataset_id_with_http_info(dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tags_by_dataset_id_with_http_info(dataset_id, **kwargs)  # noqa: E501
            return data

    def get_tags_by_dataset_id_with_http_info(self, dataset_id, **kwargs):  # noqa: E501
        """get_tags_by_dataset_id  # noqa: E501

        Get all tags of a dataset  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tags_by_dataset_id_with_http_info(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: list[TagData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tags_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_tags_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[TagData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def perform_tag_arithmetics(self, body, dataset_id, **kwargs):  # noqa: E501
        """perform_tag_arithmetics  # noqa: E501

        performs tag arithmetics to compute a new bitmask out of two existing tags and optionally create a tag for it  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.perform_tag_arithmetics(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagArithmeticsRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: TagArithmeticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.perform_tag_arithmetics_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.perform_tag_arithmetics_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
            return data

    def perform_tag_arithmetics_with_http_info(self, body, dataset_id, **kwargs):  # noqa: E501
        """perform_tag_arithmetics  # noqa: E501

        performs tag arithmetics to compute a new bitmask out of two existing tags and optionally create a tag for it  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.perform_tag_arithmetics_with_http_info(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagArithmeticsRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: TagArithmeticsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method perform_tag_arithmetics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `perform_tag_arithmetics`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `perform_tag_arithmetics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/arithmetics', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagArithmeticsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def perform_tag_arithmetics_bitmask(self, body, dataset_id, **kwargs):  # noqa: E501
        """perform_tag_arithmetics_bitmask  # noqa: E501

        Performs tag arithmetics to compute a new bitmask out of two existing tags. Does not create a new tag regardless if newTagName is provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.perform_tag_arithmetics_bitmask(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagArithmeticsRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: TagBitMaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.perform_tag_arithmetics_bitmask_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.perform_tag_arithmetics_bitmask_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
            return data

    def perform_tag_arithmetics_bitmask_with_http_info(self, body, dataset_id, **kwargs):  # noqa: E501
        """perform_tag_arithmetics_bitmask  # noqa: E501

        Performs tag arithmetics to compute a new bitmask out of two existing tags. Does not create a new tag regardless if newTagName is provided  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.perform_tag_arithmetics_bitmask_with_http_info(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagArithmeticsRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: TagBitMaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method perform_tag_arithmetics_bitmask" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `perform_tag_arithmetics_bitmask`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `perform_tag_arithmetics_bitmask`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/arithmetics/bitmask', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TagBitMaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tag_by_tag_id(self, body, dataset_id, tag_id, **kwargs):  # noqa: E501
        """update_tag_by_tag_id  # noqa: E501

        update information about a specific tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tag_by_tag_id(body, dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagUpdateRequest body: updated data for tag (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tag_by_tag_id_with_http_info(body, dataset_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tag_by_tag_id_with_http_info(body, dataset_id, tag_id, **kwargs)  # noqa: E501
            return data

    def update_tag_by_tag_id_with_http_info(self, body, dataset_id, tag_id, **kwargs):  # noqa: E501
        """update_tag_by_tag_id  # noqa: E501

        update information about a specific tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tag_by_tag_id_with_http_info(body, dataset_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagUpdateRequest body: updated data for tag (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID tag_id: ObjectId of the tag (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id', 'tag_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tag_by_tag_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_tag_by_tag_id`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `update_tag_by_tag_id`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `update_tag_by_tag_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/{tagId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upsize_tags_by_dataset_id(self, body, dataset_id, **kwargs):  # noqa: E501
        """upsize_tags_by_dataset_id  # noqa: E501

        Upsize all tags for the dataset to the current size of the dataset. Use this after adding more samples to a dataset with an initial-tag. | Creates a new tag holding all samples which are not yet in the initial-tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsize_tags_by_dataset_id(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagUpsizeRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.upsize_tags_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.upsize_tags_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
            return data

    def upsize_tags_by_dataset_id_with_http_info(self, body, dataset_id, **kwargs):  # noqa: E501
        """upsize_tags_by_dataset_id  # noqa: E501

        Upsize all tags for the dataset to the current size of the dataset. Use this after adding more samples to a dataset with an initial-tag. | Creates a new tag holding all samples which are not yet in the initial-tag.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upsize_tags_by_dataset_id_with_http_info(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TagUpsizeRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsize_tags_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `upsize_tags_by_dataset_id`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `upsize_tags_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/tags/upsize', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
